classdef PyProcess
   properties
        env;
        auth_both_mod;
        auth_pure_mod;
        ear_both_mod;
        ear_pure_mod;
   end

   methods
      function obj = PyProcess() 
        % pythonExe = "C:\Users\IT  CITY\AppData\Local\Programs\Python\Python310\python.exe";
        % setenv('TCL_LIBRARY', ...
        %     'C:\Users\IT  CITY\AppData\Local\Programs\Python\Python310\tcl\tcl8.6');
        pythonExe = "C:\HKUST\Project\.venv\Scripts\python.exe";     

        obj.env = pyenv;
        if strcmp(obj.env.Status, 'Loaded')
            disp('Correct virtual environment is already loaded!');
        else
            pyenv('Version', pythonExe);
        end

        % import modules
        obj.auth_both_mod = py.importlib.import_module( ...
            "Plot_singleuser_2Dfeature_usblib_decision_auth_both");
        py.importlib.reload(obj.auth_both_mod);

        obj.auth_pure_mod = py.importlib.import_module( ...
            "Plot_singleuser_2Dfeature_usblib_decision_auth_pure");
        py.importlib.reload(obj.auth_pure_mod);

        obj.ear_both_mod = py.importlib.import_module( ...
            "Plot_singleuser_2Dfeature_usblib_decision_ear_both");
        py.importlib.reload(obj.ear_both_mod);

        obj.ear_pure_mod = py.importlib.import_module( ...
            "Plot_singleuser_2Dfeature_usblib_decision_ear_pure");
        py.importlib.reload(obj.ear_pure_mod);
      end

      function x = dummy(obj,x1,x2,x3,x4,x5)
           x = 0;
           for i=1:100000000
            x = sqrt(x) + 1;
           end
      end

   end
end