clear
clc
% Full path to the interpreter you want to use

% 1.
pythonExe = "C:\HKUST\Project\.venv\Scripts\python.exe";  

% 2.
% pythonExe = "C:\Users\IT  CITY\AppData\Local\Programs\Python\Python310\python.exe";
% setenv('TCL_LIBRARY', ...
%     'C:\Users\IT  CITY\AppData\Local\Programs\Python\Python310\tcl\tcl8.6');
% 

% 3.
% pythonExe = ".venv/Scripts/python.exe";


env = pyenv;
if strcmp(env.Status, 'Loaded')
    disp('Correct virtual environment is already loaded!');
else
    pyenv('Version', pythonExe);
end


%%
delete(gcp("nocreate"))
clear
clc

L = int32(150);
K = int32(1);
window_size = int32(10);
train_size = int32(1000);
test_size = int32(600);
parpool('local', 1);

tStart = cputime;
% Background Process
bg_process = parfeval(gcp, @py_run, 1, L, K, window_size, train_size, test_size);
n = 0;
finished = false;
while ~finished
    if ~strcmp(bg_process.State, "running")
        finished = true;
        fprintf(repmat('\b', 1, n)); % Erase the previous message
    end
    tCurr = cputime;
    msg = sprintf('\n Background process state: %s, %.2f seconds \n', ...
        bg_process.State, tCurr - tStart);
    fprintf(msg);      
    n = numel(msg);      
end
result_cell = fetchOutputs(bg_process);
disp(bg_process.State);
disp(result_cell);
                         
%%
clc
