function out = py_run(case_num, L, K, window_size, max_cfo, snr, train_size, test_size, varargin)
    obj = PyProcess();
    if nargin > 8
        chosen_model = varargin{1};
    end
    switch case_num
        case "1"
            result_list = obj.auth_both_mod.main(L, K, window_size, max_cfo, ...
                snr, train_size, test_size);
        case "2"
            result_list = obj.auth_pure_mod.main(L, K, window_size, max_cfo, ...
                snr, train_size, test_size);
        case "3"
            result_list = obj.ear_both_mod.main(L, K, window_size, max_cfo, ...
                snr, train_size, test_size);
        case "4"
            result_list = obj.ear_pure_mod.main(L, K, window_size, max_cfo, ...
                snr, train_size, test_size);
        otherwise
            error('Case number should be one of the {"1","2","3","4"}');
    end

    x1 = double(result_list{1});
    x2 = double(result_list{2}); 
    xx = double(result_list{3});
    yy = double(result_list{4});
    z = double(result_list{5});
    arp_gt = double(result_list{6});
    cfo_gt = double(result_list{7});
    
    out = {x1, x2, xx, yy, z, arp_gt, cfo_gt};
end



% Sequence length constraint
% PUCCH | Zadoff-Chu (ZC)| 12-144| L=12k,k=1,2,…,12
% PRACH | Zadoff-Chu (ZC) | 839 and 139 | Only two case
% SRS   | Zadoff-Chu (ZC)| 6-3264 | L=6k,k=1,2,…,554
% 
% 参考来源：www.sharetechnote.com  
% - 5G PUCCH: https://www.sharetechnote.com/html/5G/5G_PUCCH.html  
% - 5G PRACH: https://www.sharetechnote.com/html/5G/5G_PRACH.html  
% - 5G SRS: https://www.sharetechnote.com/html/5G/5G_SRS.html
% 
% Number of user constraint
% K≤10%*L.
% 
% CFO max constraint
% 0.001≤CFO_max≤0.006.
