function [MSEdB_FOV,MSEdB_ARP,MSEdB_CFO] = sim_arp_cfo(T,L,K,f_cfo_max,cishu,SNRqujian)
% 20251122
pk=5;
M=2;
c=floor(L*M/(2*0.1*L));

zcset=zcseq(L);
zc1=(zcset(1,:)).'/sqrt(L);zc1=circmat(zc1); % ZC seq

induser=round(0:L/K:L-1)+1;
vk_set=repmat(zc1(:,induser),T,1);

l=(0:T*L-1)';
qhmat=kron(eye(T),ones(1,L));
for cs=1:length(SNRqujian)
SNRdB=SNRqujian(cs);
parfor ci=1:cishu
    h_k_set=(randn(T,K)+1i*randn(T,K))/sqrt(2);
    h_k_set=kron(h_k_set,ones(L,1));
    f_k_set=rand(1,K)*f_cfo_max*2-f_cfo_max;

    wk_set=exp(2i*pi*f_k_set.*l);
    fov=sqrt(L*pk)*h_k_set.*wk_set;

    rt=sum(fov.*vk_set,2);
    rt=awgn(rt,SNRdB);

    skt=rt./vk_set;
    % HLP = IUIsuppressor(skt,M,c);
    HLP = IUIsuppressor2(skt,T,L,M,c);

    nltrue=sum(abs(fov).^2,1);
    MSE_k(ci,:)=sum(abs(HLP-fov).^2,1)./nltrue;

    ykt=qhmat*(vk_set.*conj(HLP));
    ARP=mean(abs(ykt).^2,1);
    ykt_true=qhmat*(vk_set.*conj(IUIsuppressor2(fov,T,L,M,c)));
    ARP_true=mean(abs(ykt_true).^2,1);

    CFO_k=mean(angle(HLP(2:end,:)./HLP(1:end-1,:)),1)/(2*pi);

    MSE_k_ARP(ci,:)=abs(ARP_true-ARP).^2./abs(ARP_true).^2;
    MSE_k_CFO(ci,:)=abs(f_k_set-CFO_k).^2;
end
MSEdB_FOV(cs,:)=mean(MSE_k,1);
MSEdB_ARP(cs,:)=mean(MSE_k_ARP,1);
MSEdB_CFO(cs,:)=mean(MSE_k_CFO,1);
end
end